#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define NOP                     127
#define KAZ_DS_SP_SECURITY      128

#define KAZ_DS_SP_N             "49620530728628930118156860850549439958576619344146543932695595611002684\
                                 68433879052996996579124346821800802464304723640429503137601278290422409\
                                 95527312709676289355510007021292609214718910488137446101810018769075119\
                                 88095470840869628401364260569885219872313936630092234781649521258974640\
                                 44412149392265"

#define KAZ_DS_SP_G             "28162044041641820629465213530311812520424733280591982719777072727969423\
                                 41881221777905880000276398872526521617140829106163024298942797615952821\
                                 07577772474783661134923546958991344064986100286187315580133467135795054\
                                 81046792242895346009520968581918354710616860561981427356231758405817500\
                                 78616232430017"

#define KAZ_DS_SP_ORDERG        "10500977856155669343341378650844275959340676915902023228993774799159397\
                                 54823504000"

#define KAZ_DS_SP_LENPHIORDERG  266

#define KAZ_DS_SP_R             "79443391903740792834012730710871936918652310279348682922734849966178606\
                                 72052596163691236500429963779460579836821519694507657430464501977192758\
                                 86222350218902956983325658646251847925276996281522994634810263004297561\
                                 30944631192109668395074461325427240486721865536346102977356624116516200\
                                 3993959187127"

#define KAZ_DS_SP_GRg           "7592792363226369487188000"

#define KAZ_DS_ALPHABYTES       35
#define KAZ_DS_V1BYTES          12
#define KAZ_DS_V2BYTES          18
#define KAZ_DS_V3BYTES          18
#define KAZ_DS_S1BYTES          35
#define KAZ_DS_S2BYTES          29
#define KAZ_DS_S3BYTES          18

extern void KAZ_DS_OrderBase(mpz_t Modular,
                             mpz_t FiModular,
                             mpz_t Base,
                             mpz_t OrderBase);
extern int KAZ_DS_GET_PFactors(mpz_t input);
extern void KAZ_DS_PFactors(mpz_t ord,
                            mpz_t *pfacs,
                            int *qlist,
                            int *elist);
extern void KAZ_DS_CRT(mpz_t product_of_modulus,
                       mpz_t *moduluss,
                       mpz_t *candidate,
                       int no_of_elements,
                       mpz_t crt);
extern char* KAZ_DS_MLOG(mpz_t Modular,
                        mpz_t OrderBase,
                        mpz_t Base,
                        mpz_t Target,
                        mpz_t *pfactors,
                        int *qlist,
                        int *elist,
                        int saiz,
                        mpz_t kaz_crt);
extern void KAZ_DS_KeyGen(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);
extern void KAZ_DS_RANDOM(int lb,
                          int ub,
                          mpz_t out);


#endif // FILE_H_INCLUDED
