#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define KAZ_DS_SP_J             290
#define KAZ_DS_SP_K             192

#define KAZ_DS_SP_N             "45270226948514368165775452961057104066024513583128431521401468056454291\
                                 98774458998264508115001407577476189110069778987775571172926436031537112\
                                 71024355222525238401732168678469062743527399591940973619704601483783649\
                                 87805088900779941685098413385602236971769967496627324367197649739406811\
                                 96632746522079328773659567437300075198412753908132966536832277557814985\
                                 61672833966431797901251588725421494767339799532167222330732713940844086\
                                 14250426959307061307643753653312904782978336234325102647863499814149451\
                                 25817042915487535578532612112806348661381188312992540411854075237945169\
                                 48596349973481847037159572611330249254316565484112598661974759035547226\
                                 48151545016997538549699615000839564858099505173470938167685881935809614\
                                 03750393318582543335207164453993979866150122840001068441020877053293649\
                                 2791177711328251597455"

#define KAZ_DS_SP_G             "6007"

#define KAZ_DS_SP_Gg            "24400121576165027485840240203472394035664130190825960812149593068926964\
                                 82316926867755817267716119024722090598174818234951600983691489167899171\
                                 40716663937581759316360537504000"

#define KAZ_DS_SP_nPHIGg        573

#define KAZ_DS_SP_R             "6151"

#define KAZ_DS_SP_GRg           "1690404083586125425143844520333180405256000"

#define KAZ_DS_SP_Q             "5486564774100228890224051645591864666997607634979815749827"

#define KAZ_DS_SP_PHIQ2O2       "15051196510198747836445417641478829560689759950903308404851366710422509\
                                 536304524851790111630869370027305033217390051"

#define KAZ_DS_ALPHABYTES       73
#define KAZ_DS_V1BYTES          43
#define KAZ_DS_V2BYTES          33
#define KAZ_DS_S1BYTES          67
#define KAZ_DS_S2BYTES          67

extern void KAZ_DS_OrderBase(mpz_t Modular,
                             mpz_t FiModular,
                             mpz_t Base,
                             mpz_t OrderBase);
extern int KAZ_DS_GET_PFactors(mpz_t input);
extern void KAZ_DS_PFactors(mpz_t ord,
                            mpz_t *pfacs,
                            int *qlist,
                            int *elist);
extern void KAZ_DS_CRT(mpz_t product_of_modulus,
                       mpz_t *moduluss,
                       mpz_t *candidate,
                       int no_of_elements,
                       mpz_t crt);
extern char* KAZ_DS_MLOG(mpz_t Modular,
                        mpz_t OrderBase,
                        mpz_t Base,
                        mpz_t Target,
                        mpz_t *pfactors,
                        int *qlist,
                        int *elist,
                        int saiz,
                        mpz_t kaz_crt);
extern void KAZ_DS_KeyGen(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);
extern void KAZ_DS_RANDOM(int lb,
                          int ub,
                          mpz_t out);


#endif // FILE_H_INCLUDED
