#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define KAZ_DS_SP_J             390
#define KAZ_DS_SP_K             256

#define KAZ_DS_SP_N             "38398657910660434609973989276984340612873495919166053233708904413496642\
                                 42212856419111494938721316140731818764898730987834645157071345309078510\
                                 48171344865904435974088696685916194141834062947693694234351253584552740\
                                 72543154939411457197415243877336715321119845568305004633482349076162669\
                                 96131268868484891396410878752273768220192585937110849135944814220470967\
                                 79914854375068701341731204807619916064356212239679178752964692613680000\
                                 11762377698986907772033363426786758575319526948025031745407297054463234\
                                 56614314513805318305138302588579237630624991887507072373893562752147800\
                                 51088196954262320438999464483730650968575657646976765451447669522758546\
                                 33653980284467444985988198716465500648517905365689022557647488181187124\
                                 17942806112356630612303713955260503452697878014021493260893537651492340\
                                 97815331206317876980556661013018240985702096336259279828046324535723294\
                                 64488002804673020872474797544632154428414320673128995442575893216699791\
                                 94666031484532342648385688854977548147206579907053842314449041646365366\
                                 59901579819968285305622979441976415793594097998811439173365820221947491\
                                 65131381891422125322500199413252708902879567292385784470725425564482776\
                                 635"

#define KAZ_DS_SP_G             "6007"

#define KAZ_DS_SP_Gg            "18735625925307486059624420380679030456893180616975208652807321374767281\
                                 68506260672285454558035401318530998129056482725570256639047337185467493\
                                 40664036280760356444134884792409211689721665464244733024320757045280772\
                                 04197803207607072000"

#define KAZ_DS_SP_nPHIGg        769

#define KAZ_DS_SP_R             "6151"

#define KAZ_DS_SP_GRg           "17563272276772899418951285020710841730008749107651330392000"

#define KAZ_DS_SP_Q             "11253090236274690452655775486995115479054469572473819203858180153799999\
                                 7651347"

#define KAZ_DS_SP_PHIQ2O2       "63316019932870384298740854824102996394188543195569738463447055785417973\
                                 55007469903796535235531162953632053473642650480617418267634716781470919\
                                 758086631531"

#define KAZ_DS_ALPHABYTES       98
#define KAZ_DS_V1BYTES          58
#define KAZ_DS_V2BYTES          33
#define KAZ_DS_S1BYTES          90
#define KAZ_DS_S2BYTES          90

extern void KAZ_DS_OrderBase(mpz_t Modular,
                             mpz_t FiModular,
                             mpz_t Base,
                             mpz_t OrderBase);
extern int KAZ_DS_GET_PFactors(mpz_t input);
extern void KAZ_DS_PFactors(mpz_t ord,
                            mpz_t *pfacs,
                            int *qlist,
                            int *elist);
extern void KAZ_DS_CRT(mpz_t product_of_modulus,
                       mpz_t *moduluss,
                       mpz_t *candidate,
                       int no_of_elements,
                       mpz_t crt);
extern char* KAZ_DS_MLOG(mpz_t Modular,
                        mpz_t OrderBase,
                        mpz_t Base,
                        mpz_t Target,
                        mpz_t *pfactors,
                        int *qlist,
                        int *elist,
                        int saiz,
                        mpz_t kaz_crt);
extern void KAZ_DS_KeyGen(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);
extern void KAZ_DS_RANDOM(int lb,
                          int ub,
                          mpz_t out);


#endif // FILE_H_INCLUDED
