#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define KAZ_DS_SP_J             258
#define KAZ_DS_SP_K             192

#define KAZ_DS_SP_N             "46759781633193085932210580959238145383675146627658021160776703660197662\
                                 84309095575706469428835436474742770048322861396175300317303624223782655\
                                 81734794282984690028150157145980074281292566731770571423749001321999800\
                                 37404276736920556580598591738277536884367979898734058882667256768293478\
                                 95884839152754674991232442195397685281964144115888733328833506735072089\
                                 57623885149982409768782662260256033583088295537760922309998149698910449\
                                 36428489972477942044730377618695999472542904676257903550630694646196235\
                                 20975140597282373675602319098855616251701113212350825145004011369716720\
                                 14897642672510064283349035886954252913240104862836223024721351047469380\
                                 982094744623689350493066107951410660778357687057201251046585"

#define KAZ_DS_SP_G             "6007"

#define KAZ_DS_SP_Gg            "22454043250428773247460909028042207884161972004320225533938655455928952\
                                 57883733275592608066918868457698539827892596863237792058786088397050704\
                                 0858655740241632000"

#define KAZ_DS_SP_nPHIGg        530

#define KAZ_DS_SP_R             "6151"

#define KAZ_DS_SP_GRg           "1690404083586125425143844520333180405256000"

#define KAZ_DS_SP_q             "11895619350993386875456242620986134287933857699324710917839"

#define KAZ_DS_SP_Q             "660867741721854826414235701165896349329658761073595050991"

#define KAZ_DS_SP_PHIQ2         "14150575974372832677641345708532346672270354638291325385141558600858291\
                                 1782007642521215611739550116507386521097512082"

#define KAZ_DS_SP_BETA          3

#define KAZ_DS_ALPHABYTES       68
#define KAZ_DS_V1BYTES          43
#define KAZ_DS_V2BYTES          33
#define KAZ_DS_S1BYTES          67
#define KAZ_DS_S2BYTES          67

extern void KAZ_DS_OrderBase(mpz_t Modular,
                             mpz_t FiModular,
                             mpz_t Base,
                             mpz_t OrderBase);
extern int KAZ_DS_GET_PFactors(mpz_t input);
extern void KAZ_DS_PFactors(mpz_t ord,
                            mpz_t *pfacs,
                            int *qlist,
                            int *elist);
extern void KAZ_DS_CRT(mpz_t product_of_modulus,
                       mpz_t *moduluss,
                       mpz_t *candidate,
                       int no_of_elements,
                       mpz_t crt);
extern char* KAZ_DS_MLOG(mpz_t Modular,
                        mpz_t OrderBase,
                        mpz_t Base,
                        mpz_t Target,
                        mpz_t *pfactors,
                        int *qlist,
                        int *elist,
                        int saiz,
                        mpz_t kaz_crt);
extern void KAZ_DS_KeyGen(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);
extern void KAZ_DS_RANDOM(int lb,
                          int ub,
                          mpz_t out);


#endif // FILE_H_INCLUDED
