#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define KAZ_DS_SP_J             180
#define KAZ_DS_SP_K             134

#define KAZ_DS_SP_N             "16654099924025690560880991628826166333626342440673565018885011847989446\
                                 73390411604901732676624210376510769252181354174828223286340057028944019\
                                 91339669414651118456372695070769619863131971414241586048862803140660472\
                                 06653222207353469933659597534156792443205461406819169388949586947835045\
                                 09315984550444746877596669802184487731229941008215513808488975493742420\
                                 95332359872258964174269418980707061566230310986271334632962653419873630\
                                 52884725941333218996085207555"
#define KAZ_DS_SP_n             1509

#define KAZ_DS_SP_Q             "116431182179248680450031658440253681535"
#define KAZ_DS_SP_PHIQ          "27739969042773783995307880611840000000"
#define KAZ_DS_SP_PHIPHIQ       "4794067407163270021663791513600000000"

#define KAZ_DS_SP_G             "6007"
#define KAZ_DS_SP_Gg            "66425249147392035103359575563682919206231140688573787652572381678879876\
                                 350990985890249087277450456295776000"
#define KAZ_DS_SP_PHIGg         "69025991055271083563108509669543205198091379906257170576075063002464606\
                                 15498054972211200000000000000000000"
#define KAZ_DS_SP_nPHIGg        352

#define KAZ_DS_SP_R             "6151"
#define KAZ_DS_SP_GRg           "964284630129748924872876000"
#define KAZ_DS_SP_PHIGRg        "137005430034525396664320000"
#define KAZ_DS_SP_PHIPHIGRg     "25983496793805532692480000"

#define KAZ_DS_SP_PHIGRgQ       "13195170808477513128033647660316185885361748971324702720000000000"

#define KAZ_DS_SP_q             "19622981469770784085257257918661917296793"
#define KAZ_DS_SP_GRgqQ         "22031270630348972597475958430799310183802415569685291109901764549819429\
                                 48469701999741238400477230275380000"
#define KAZ_DS_SP_PHIGRgqQ      "25892859226521461587603410482490403883967390885193816188766111333437628\
                                 0005852670907715409674240000000000"

#define KAZ_DS_ALPHABYTES       44
#define KAZ_DS_VBYTES           28
#define KAZ_DS_WABYTES          8
#define KAZ_DS_WBBYTES          8
#define KAZ_DS_SBYTES           44

extern void KAZ_DS_OrderBase(mpz_t Modular,
                             mpz_t FiModular,
                             mpz_t Base,
                             mpz_t OrderBase);
extern int KAZ_DS_GET_PFactors(mpz_t input);
extern void KAZ_DS_PFactors(mpz_t ord,
                            mpz_t *pfacs,
                            int *qlist,
                            int *elist);
extern void KAZ_DS_CRT(int t,
                       mpz_t *c,
                       mpz_t *modular,
                       mpz_t crt);
extern char* KAZ_DS_MLOG(mpz_t Modular,
                        mpz_t OrderBase,
                        mpz_t Base,
                        mpz_t Target,
                        mpz_t *pfactors,
                        int *qlist,
                        int *elist,
                        int saiz,
                        mpz_t kaz_crt);
extern void KAZ_DS_KeyGen(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);
extern void KAZ_DS_RANDOM(int lb,
                          int ub,
                          mpz_t out);


#endif // FILE_H_INCLUDED
