#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define KAZ_DS_SP_J             342
#define KAZ_DS_SP_K             264

#define KAZ_DS_SP_N             "30899362774728472813402930925487036907106483346647716077832634208229681\
                                 07962531959560734241391989405902366462221337187560519416251260064227321\
								 06082661590352303925527901201649129580788573960957561028357743279687597\
								 49747093923591891123458617559793839630888839380383467100321876543562470\
								 61213362062661781337190905193292194662760631531056601921913504527118481\
								 07751097959142127323425808395861273332029465928667158860142396207859547\
								 78074498210759279292914531779253175131250490084164756441584869258201928\
								 79176273406824851209859013869638544117670990182233017528174921752629661\
								 34447192602843362332140861676394949320021847435153149372476489431241044\
								 28276272016473019197824141603018603454800125471918276469216414911571746\
								 72668460962414066198498060543077953704972271607635447719007749148942649\
								 87742361898493588046610193221237596798824666142659564842708753580397824\
								 21147842091321191449445360355615922323298778630163320925180315247799589\
								 41928935694291900698197859164061901699987617335054045"

#define KAZ_DS_SP_n             3241

#define KAZ_DS_SP_Q             "116431182179248680450031658440253681535"
#define KAZ_DS_SP_PHIQ          "27739969042773783995307880611840000000"
#define KAZ_DS_SP_PHIPHIQ       "4794067407163270021663791513600000000"

#define KAZ_DS_SP_G             "6007"
#define KAZ_DS_SP_Gg            "96059821280249872265677090702570913737189042824952577209123768240900395\
                                 89464671236957581880496651416879818119211924634227799514556644249432529\
								 5808384132307951500465714586248917282644088562258250887665096381408000"
#define KAZ_DS_SP_PHIGg         "89861812740620146344786438298481275862803681589346043731300665246260601\
                                 56859518840709686514679451487774899492452429957871629891092712671935582\
								 789205246857855113751804533407051100979200000000000000000000000000000"
#define KAZ_DS_SP_nPHIGg        701

#define KAZ_DS_SP_R             "6151"
#define KAZ_DS_SP_GRg           "5200850540945483985475654433139129917088761950740696000"
#define KAZ_DS_SP_PHIGRg        "623751237884677791155933417047675732129480704000000000"
#define KAZ_DS_SP_PHIPHIGRg     "100121629276013593400001650240429335322296320000000000"

#define KAZ_DS_SP_GRgQ          "60554117681986769467331262847316573933514611434672914685497030700541650\
                                 7142787734148248360000"
#define KAZ_DS_SP_PHIGRgQ       "68780196302356030161300834552816886672889571369623389948544959018168261\
                                 317073305600000000000"

#define KAZ_DS_SP_q             "26627523777905975589433210335190787380474989321172119143295448226998084\
                                 992136013"
#define KAZ_DS_SP_GRgq          "13848577144436103051841282674979919307163069528012943758699908775237862\
                                 0316043845835189623731598247818225216131513221740440526285048000"
#define KAZ_DS_SP_GRgqQ         "16124062084272193810503267739789273235330810194198857714348261168910241\
                                 53061768482098474645353938433545957273587681694835434902019364862227802\
								 0032850473939289318824188680000"
#define KAZ_DS_SP_PHIGRgqQ      "18314463124900258531257260357127929113961906055984247833589668020090265\
                                 41544577488585675157496000751623713328489178671705956313150653126368759\
								 986841447329641267200000000000"
								 
#define KAZ_DS_SP_qQ   			"31002740719676467235823433638273198069687052879447053513553066041365473\
                                 99135229919408136556692622191082265246706619955"
#define KAZ_DS_SP_PHIqQ   		"73864668528483459817170863386335683441528649700786865352490218669177573\
                                 3977327210629920264562615096963057582080000000"

#define KAZ_DS_ALPHABYTES       88
#define KAZ_DS_BBYTES	        88
#define KAZ_DS_V1BYTES          56
#define KAZ_DS_V2BYTES          50
#define KAZ_DS_SBYTES           72

extern void KAZ_DS_OrderBase(mpz_t Modular, mpz_t FiModular, mpz_t Base, mpz_t OrderBase);

extern int KAZ_DS_GET_PFactors(mpz_t input);

extern void KAZ_DS_PFactors(mpz_t ord, mpz_t *pfacs, int *qlist, int *elist);

extern void KAZ_DS_CRT(int t, mpz_t *c, mpz_t *modular, mpz_t crt);

extern char* KAZ_DS_MLOG(mpz_t Modular,
                        mpz_t OrderBase,
                        mpz_t Base,
                        mpz_t Target,
                        mpz_t *pfactors,
                        int *qlist,
                        int *elist,
                        int saiz,
                        mpz_t kaz_crt);
						
extern void KAZ_DS_RANDOM(int lb, int ub, mpz_t out);

extern void KAZ_DS_KeyGen(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);

#endif // FILE_H_INCLUDED
