#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define KAZ_DS_SP_J             128
#define KAZ_DS_SP_K             128

#define KAZ_DS_SP_N   			"36074125839713232195900037838349442849885202263194537439069698009198951\
								 76551430071528816513023400139449183391549534086592248781036129317137092\
								 03748356339934662361455775104479726899100647924875923316015883645117612\
								 15345407301312219847791817434306554847172231930077054686259201955274563\
								 60287632608176655"

#define KAZ_DS_SP_G             "6007"
#define KAZ_DS_SP_Gg            "23102151283542472555351033031857407110549489214984451103786304558150674\
								 606117088000"
#define KAZ_DS_SP_LGg         	274

#define KAZ_DS_SP_R             "6151"
#define KAZ_DS_SP_GRg           "399620650696124709852000"
#define KAZ_DS_SP_PHIGRg        "60408037934094090240000"
#define KAZ_DS_SP_PHIPHIGRg     "11456568251237007360000"
#define KAZ_DS_SP_LGRg         	79

#define KAZ_DS_SP_Q             "116431182179248680450031658440253681535"
#define KAZ_DS_SP_PHIQ          "27739969042773783995307880611840000000"

#define KAZ_DS_SP_q             "174191248036859359750069958033351987111"

#define KAZ_DS_SP_qQ			"20281292934210266180015077617164138187062358205754874035144120680125618\
								 695385"
#define KAZ_DS_SP_PHIqQ			"48320598280646083142285085438427361181289947006092758373675065933824000\
								 00000"

#define KAZ_DS_SKBYTES    		42
#define KAZ_DS_V1BYTES          10
#define KAZ_DS_V2BYTES          32
#define KAZ_DS_SBYTES           42

extern void KAZ_DS_OrderBase(mpz_t Modular, mpz_t FiModular, mpz_t Base, mpz_t OrderBase);

extern int KAZ_DS_GET_PFactors(mpz_t input);

extern void KAZ_DS_PFactors(mpz_t ord, mpz_t *pfacs, mpz_t *qlist, int *elist);

extern void KAZ_DS_CRT(int t, mpz_t *c, mpz_t *modular, mpz_t crt);

extern char* KAZ_DS_MLOG(mpz_t Modular,
                        mpz_t OrderBase,
                        mpz_t Base,
                        mpz_t Target,
                        mpz_t *pfactors,
                        int *qlist,
                        int *elist,
                        int saiz,
                        mpz_t kaz_crt);
						
extern void KAZ_DS_RANDOM(int lb, int ub, mpz_t out);

extern void KAZ_DS_KeyGen(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);

#endif // FILE_H_INCLUDED
