#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define NOP                     200
#define KAZ_DS_SP_SECURITY      192

#define KAZ_DS_SP_N             "30399165618737055253218678241303232169321402171641521661339974250900550\
                                 79463311113908137653886081551571535229675344056779812944582485268094089\
                                 14703939942640013142585411652084080298452503582315445879592596607073950\
                                 05942713701944765192291648836262216460893841258152532480126386264782399\
                                 66083387100027092931323910388906166911235513362491555418250186439541249\
                                 74579574922930584024810200275283323678717488160270593856938058587074959\
                                 26658732539761792596484372802443506665618237684168502746245996876858353\
                                 9424319191284696295"

#define KAZ_DS_SP_G             "28230787961570157561557341641245305374301580388609876657681476106512279\
                                 41891807030753709268144314768870756646264903970362546868745077171075008\
                                 91200203648867398758393547081293628259508888438873112673215114598347476\
                                 90313300956671200947705292760870671674208655741251656363713526995583712\
                                 46605427018617672220584464226026921121593079579137562086218175907324427\
                                 10860653573065721359372649518434801699548657278281453411256933673601309\
                                 13510133130853949885652423053947521592759615077536899894755791194586717\
                                 4055795749309008877"

#define KAZ_DS_SP_ORDERG        "32641495390250379666330683687179879571537692910451506884367660674475546\
                                 168966873442138143169109968179770608247497619200"

#define KAZ_DS_SP_LENPHIORDERG  391

#define KAZ_DS_SP_R             "36280911415381129012988126383439033338738677832699748910336792455085083\
                                 92222496378170847839407202639903068349641635880651492518065149574226501\
                                 86692037345698631780381707187783667203981068218577292904734073150399489\
                                 61950334304247754342561127827265906110663785695070367854661252676123496\
                                 89214397034632683949171298197211338018530789150344567233818360671718081\
                                 46355849146407909673631510712333932382474967058270023227597939046429071\
                                 41677284919877162769811379298148660853942536959286816266981881680258118\
                                 999693755376573849"

#define KAZ_DS_SP_GRg           "35678531314800710220296412000"

#define KAZ_DS_ALPHABYTES       50
#define KAZ_DS_V1BYTES          13
#define KAZ_DS_V2BYTES          27
#define KAZ_DS_V3BYTES          27
#define KAZ_DS_S1BYTES          51
#define KAZ_DS_S2BYTES          38
#define KAZ_DS_S3BYTES          27

extern void KAZ_DS_OrderBase(mpz_t Modular,
                             mpz_t FiModular,
                             mpz_t Base,
                             mpz_t OrderBase);
extern int KAZ_DS_GET_PFactors(mpz_t input);
extern void KAZ_DS_PFactors(mpz_t ord,
                            mpz_t *pfacs,
                            int *qlist,
                            int *elist);
extern void KAZ_DS_CRT(mpz_t product_of_modulus,
                       mpz_t *moduluss,
                       mpz_t *candidatex,
                       int no_of_elements,
                       mpz_t crt);
extern char* KAZ_DS_MLOG(mpz_t Modular,
                        mpz_t OrderBase,
                        mpz_t Base,
                        mpz_t Target,
                        mpz_t *pfactors,
                        int *qlist,
                        int *elist,
                        int saiz,
                        mpz_t kaz_crt);
extern void KAZ_DS_KeyGen(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);
extern void KAZ_DS_RANDOM(int lb,
                          int ub,
                          mpz_t out);


#endif // FILE_H_INCLUDED
